package tomek.it.graphics;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;


public class CardPanel07b {
	
	private static final Logger log = LogManager.getLogger(CardPanel07b.class);	
	
	private final static DateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
	
	private final static int defaultWidth = 320;
	private final static int defaultHeight = 240;

	private final static String[] countries = { "Afghanistan", "Albania", "Argentina", "Austria", "Belgium", "Brazil",
			"Cambodia", "Cameroon", "Canada", "Chile", "China", "Colombia", "Costa Rica", "Croatia", "Czech Republic",
			"Denmark", "Egypt", "France", "Germany", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Ireland",
			"Israel", "Italy", "Jamaica", "Japan", "Kenya", "Mexico", "Morocco", "Nepal", "Netherlands", "New Zealand",
			"Nigeria", "Norway", "Peru", "Philippines", "Poland", "Portugal", "Romania", "Russia", "Saudi Arabia",
			"Serbia", "Slovakia", "South Africa", "South Korea", "Spain", "Sweden", "Switzerland", "Thailand",
			"Ukraine", "United States", "Uruguay", "No File", "Wrong Format", };
	private final static int POLAND = 39;

	final private static JLabel labelFlag = new JLabel();
	final private static JLabel labelHTML = new JLabel();

	private final static Icon[] countriesIcon = new Icon[countries.length];
	private final static String[] countriesIconError = new String[countries.length];
	private final static String[] countriesHTML = new String[countries.length];
	private final static String[] countriesHTMLError = new String[countries.length];

	public final static String FLAG_NO_FILE = "<html><font color='red' size=+1><P>ERROR</P><P>File not found.</P></font></html>";
	public final static String FLAG_WRONG_FILE = "<html><font color='red' size=+1><P>ERROR</P><P>Wrong format.</P></font></html>";
	
	private final static Set<ParserTask> set = Collections.synchronizedSet(new HashSet<ParserTask>());
	private final static ExecutorService pool = Executors.newFixedThreadPool(5);
	
	private static void createAndShowGUI() {

		Configurator.initialize(new DefaultConfiguration());
	    Configurator.setRootLevel(Level.TRACE);
		
		JFrame f = new JFrame("CardLayout DEMO");

		final JPanel control = new JPanel(new GridLayout());
		final JButton jbuttonNext = new JButton();
		final JButton jbuttonPrevious = new JButton();
		final JComboBox<String> jlist = new JComboBox<String>(countries);

		final ImageIcon iiPrevious = new ImageIcon("ICON/arrow-left_red.png");
		final ImageIcon iiNext = new ImageIcon("ICON/arrow-right_red.png");

		final JPanel cards = new JPanel(new CardLayout());
		final String FLAG = "FLAG";
		final String HTML = "HTML";
		final JPanel jpFlag = new JPanel();
		final JPanel jpHTML = new JPanel();
		

		
		ActionListener myActionListener = new ActionListener() {
			
			int i;
			
			public synchronized void actionPerformed(ActionEvent e) {
				i = jlist.getSelectedIndex();
				
				if (e.getSource().equals(jbuttonNext)) {
					i++;
					if (i == countries.length)
						i = 0;
					jlist.setSelectedIndex(i);
					log.trace("[ActionListener]: NEXT Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				if (e.getSource().equals(jbuttonPrevious)) {
					i--;
					if (i < 0)
						i = countries.length - 1;
					jlist.setSelectedIndex(i);
					log.trace("[ActionListener]: PREVIOUS Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				log.error("[ActionListener] Unknown object...");
			}
		};

		MouseListener myMouseListener = new MouseListener() {

			CardLayout cl = (CardLayout) cards.getLayout();
			int i;

			public void mouseClicked(MouseEvent e) {}

			public synchronized void mousePressed(MouseEvent e) {
				i = jlist.getSelectedIndex();
				cl.next(cards);
				if (jpFlag.isVisible()) {
					log.trace("[MouseListener]: "+ "Selected FLAG Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelFlag.getName()+"\"");
					// If previously set valid flag - skipping
					if(countries[i]!=labelFlag.getName()) setLabelFlag(i);
					return;
				}
				else if (jpHTML.isVisible()) {
					log.trace("[MouseListener]: "+ "Selected HTML Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelHTML.getName()+"\"");
					// If previously set valid HTML - skipping
					if(countries[i]!=labelHTML.getName()) setLabelHTML(i);
				}
				else {
					log.error("[MouseListener]: WRONG PANEL... ");
				}
			}

			public void mouseReleased(MouseEvent e) {}

			public void mouseEntered(MouseEvent e) {}

			public void mouseExited(MouseEvent e) {}

		};

		jbuttonNext.setIcon(iiNext);
		jbuttonNext.setBorderPainted(false);
		jbuttonNext.setContentAreaFilled(false);
		jbuttonNext.setBorder(null);
		jbuttonNext.setFocusPainted(false);
		jbuttonNext.setMargin(new Insets(0, 0, 0, 0));
		jbuttonNext.addActionListener(myActionListener);

		jbuttonPrevious.setIcon(iiPrevious);
		jbuttonPrevious.setBorderPainted(false);
		jbuttonPrevious.setContentAreaFilled(false);
		jbuttonPrevious.setBorder(null);
		jbuttonPrevious.setFocusPainted(false);
		jbuttonPrevious.setMargin(new Insets(0, 0, 0, 0));
		jbuttonPrevious.addActionListener(myActionListener);

		jlist.setBackground(Color.LIGHT_GRAY);
		jlist.setForeground(Color.BLUE);
		jlist.setFont(new Font("Verdana", Font.BOLD, 12));

		// JPanel - sterujący
		control.setBackground(Color.DARK_GRAY);

		control.add(jbuttonPrevious);
		control.add(jlist);
		control.add(jbuttonNext);

		// JPanel - składniki głównego okienko
		//jpFlag.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpFlag.setBackground(Color.DARK_GRAY);
		jpFlag.addMouseListener(myMouseListener);
		jpFlag.setName(FLAG);
		jpFlag.add(labelFlag);

		labelFlag.setPreferredSize(new Dimension(defaultWidth,defaultHeight));
		labelFlag.setHorizontalAlignment(JLabel.CENTER);
		labelFlag.setVerticalAlignment(JLabel.TOP);
		
		
		//jpHTML.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpHTML.setBackground(Color.DARK_GRAY);
		jpHTML.setForeground(Color.WHITE);
		jpHTML.addMouseListener(myMouseListener);
		jpHTML.setName(HTML);
		jpHTML.add(labelHTML);
		

		// https://www.vogella.com/tutorials/EclipseWindowBuilder/article.html
		jpHTML.setLayout(new BoxLayout(jpHTML, BoxLayout.PAGE_AXIS));
		jpHTML.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder(null, "Short information about the country", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, java.awt.Color.LIGHT_GRAY),
                        BorderFactory.createEmptyBorder(10,10,10,10)));
 		
		labelHTML.setVerticalAlignment(SwingConstants.TOP);
		labelHTML.setHorizontalAlignment(SwingConstants.LEFT);
		labelHTML.setForeground(Color.WHITE);
		
		
		
		
		ItemListener myItemListener = new ItemListener() {
			
			int i;
			
			public synchronized void itemStateChanged(ItemEvent ie) {
				if (ie.getStateChange()==ItemEvent.SELECTED) {
					i = jlist.getSelectedIndex();
					if (jpFlag.isVisible()) {
						log.trace("[ItemListener]: "+ "Setting FLAG Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelFlag.getName()+"\"");
						// This should always set new labelFlag
						if (countries[i]==labelFlag.getName())
							log.error("current must differ than new! \""+countries[i]+"\"==\""+labelFlag.getName()+"\"");
						setLabelFlag(i);
					}
					else if (jpHTML.isVisible()) {
						log.trace("[ItemListener]: "+ "Setting HTML Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelHTML.getName()+"\"");
						// This should always set new labelHTML
						if (countries[i]==labelHTML.getName())
							log.error("current must differ than new! \""+countries[i]+"\"==\""+labelHTML.getName()+"\"");
						setLabelHTML(i);
					} 
					else {
						log.error("[ItemListener]: WRONG PANEL... "+ ie.paramString());
					}
				}
			}
		};

		jlist.addItemListener(myItemListener);
		jlist.setSelectedIndex(POLAND);

		cards.add(jpFlag);
		cards.add(jpHTML);

		f.add(cards, BorderLayout.CENTER);
		f.add(control, BorderLayout.NORTH);

		f.pack();
		f.setLocationRelativeTo(null);
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
		
		log.trace(jpFlag.getHeight());
		log.trace(jpFlag.getWidth());
		}
	
	
	private static Icon getIconCountry(int value) throws FileNotFoundException, ClassCastException {

		String tmp = "FLAGS/" + countries[value].toLowerCase().replaceAll(" ", "-") + "-flag.png";
		log.trace("[getIconCountry]: New Icon for \""+countries[value]+"\", file: \""+tmp+"\"");
		if (!Files.exists(Paths.get(tmp))) {
			throw new FileNotFoundException(tmp);
		}
		ImageIcon image = new ImageIcon(tmp);
		if (image.getIconHeight()<=0 || image.getIconWidth()<=0) {
			throw new ClassCastException(tmp);
		}
		log.debug("[getIconCountry]: Image size: "+image.getIconHeight()+" x "+image.getIconWidth()+". Default: "+defaultHeight+" x "+defaultWidth);
		float mod = Math.max(image.getIconHeight() / (float) defaultHeight,
				image.getIconWidth() / (float) defaultWidth);
		int newHeight = (int) (0.4999 + image.getIconHeight() / mod);
		int newWidth = (int) (0.4999 + image.getIconWidth() / mod);
		log.debug("[getIconCountry]: After modification: "+newHeight+" ("+(image.getIconHeight()/mod)+") x "+newWidth+" ("+(image.getIconWidth()/mod)+")");
		
		ImageIcon image2 = new ImageIcon(image.getImage().getScaledInstance(newWidth, newHeight, Image.SCALE_SMOOTH));

		countriesIcon[value] = image2;
		return image2;
	}
	
	
	private static synchronized void setLabelHTML(int i) {

		log.trace("[setLabelHTML]: Setting HTML for \""+countries[i]+"\" ("+i+")");
		labelHTML.setName(countries[i]);

		// sprawdzam czy już ustawione
		// pobieram to co trzeba i zapusuję do tablicy, lub do tablicy błędów...
		// jeśli znowu jestem na tym focusie to ustawiam Label i name dla Label. 
		
		if (countriesHTML[i] != null) {
			log.trace("[setLabelHTML]: Use existing HTML for \""+countries[i]+"\"");			
			labelHTML.setText(countriesHTML[i]);
			return;
		}
		if (countriesHTMLError[i] != null) {
			log.trace("[setLabelHTML]: Use existing Error HTML for \""+countries[i]+"\"");			
			labelHTML.setText(countriesHTMLError[i]);
			return;
		}
		
		labelHTML.setText("loading...");
		add(new ParserTask(countries[i]));
	}

	private static void add(ParserTask parserTask) {
		if (set.add(parserTask)) {
			// New TASK (new element in the set)
			parserTask.addFuture(pool.submit(parserTask));
			log.trace("[add] "+"New "+parserTask);
			return;
		}

		ParserTask tmp = null;
		try {
			tmp = set.stream().filter(parserTask::equals).findAny().orElse(null);
			log.trace("[add] "+"Found "+tmp);

		} catch(Exception e) {
			log.error("[add] Problem with "+tmp+", "+e.getMessage());
			return;
		}
	}


	private static void setLabelFlag(int i) {

		log.trace("[setLabelFlag]: Setting Icon for \""+countries[i]+"\" ("+i+")");
		labelFlag.setName(countries[i]);
		
		if (countriesIcon[i] != null) {
			log.info("[setLabelFlag]: Use existing Icon for \""+countries[i]+"\"");		
			if (labelFlag.getText()!=null)  labelFlag.setText(null);
			labelFlag.setIcon(countriesIcon[i]);
			return;
		}
		if (countriesIconError[i] != null) {
			log.info("[setLabelFlag]: Use existing Error description for \""+countries[i]+"\"");			
			if (labelFlag.getIcon()!=null)  labelFlag.setIcon(null);
			labelFlag.setText(countriesIconError[i]);
			return;
		}
		
		try {
			if (labelFlag.getText()!=null)  labelFlag.setText(null);
			labelFlag.setIcon(getIconCountry(i));
			return;
		} catch (FileNotFoundException e) {
			log.warn("[setLabelFlag]: No Icon for \""+countries[i]+"\"");
			countriesIconError[i]=FLAG_NO_FILE;
		} catch (ClassCastException e) {
			log.warn("[setLabelFlag]: No Valid Icon for \""+countries[i]+"\"");
			countriesIconError[i]=FLAG_WRONG_FILE;
		} catch (Exception e) {
			log.warn("[setLabelFlag]: Problem with Icon for \""+countries[i]+"\"");
			countriesIconError[i]="<html><font color='red' size=+1><P>ERROR</P><P>Problems with the file.</P><P>"+e.getMessage()+"</P></font></html>";
		} finally {
			log.info("[setLabelFlag] "+labelFlag.getName()+" [ICON="+(labelFlag.getIcon()!=null ? "yes" : "no")+", ERROR="+(labelFlag.getText()!=null ? "yes" : "no")+"]");
		}
		
		if (labelFlag.getIcon()!=null)  labelFlag.setIcon(null);
		labelFlag.setText(countriesIconError[i]);				
	}
	
	
	public static void main(String[] args) {

		UIManager.put("ComboBox.selectionForeground", new ColorUIResource(Color.YELLOW));
		
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}



	private static  class ParserTask implements Runnable {
		
		private String country;
		private Future<?> future;

		public ParserTask(String string) {
			this.country = string;
		}
		
		public void addFuture(Future<?> submit) {
			this.future=submit;
		}

		public String toString() { 
			return "Task: \""+country+"\" "+(future!=null ? " (finished: "+future.isDone()+")" :"");
		}	
		
		public boolean equals(Object obj) {
			if (this == obj) return true;
			if (obj == null) return false;
			if (!(obj instanceof ParserTask)) return false;
			return this.country.equals(((ParserTask) obj).country);
		}

		public int hashCode() {
			return Objects.hash(this.country);
		}
		
		public void run() {
			Thread.currentThread().setName("Thread: "+this.country);
			log.trace("[RUN] BEGINS "+this.toString()+" ("+df.format(new Date())+")");			
			try { Thread.sleep((long) (Math.random() * 50000)); } catch (InterruptedException e) {}
			log.trace("[RUN] FINISHED "+this.toString());			
		}
		
	}

	
}
